import argparse
import os
import json
import ast
from prompt.androidControlPrompt import ANDROIDCONTROLLOWACTIONPREDICTPROMPT_FOROSATLAS, ANDROIDCONTROLHIGHACTIONPREDICTPROMPT_FOROSATLAS, ANDROIDCONTROLLOWACTIONPREDICTPROMPT_FORUITARAS, ANDROIDCONTROLHIGHACTIONPREDICTPROMPT_FORUITARAS, ANDROIDCONTROLLOWACTIONPREDICTPROMPT_FORGUIR1, ANDROIDCONTROLHIGHACTIONPREDICTPROMPT_FORGUIR1
import re
from tqdm import tqdm
import sys
sys.path.append("./")
from utils.logging_utils import setup_logger_to_stdout
from utils.schema.GUI_OWL.common import pil_to_base64, message_translate
from preprocess_base import BasePreProcess
logger = setup_logger_to_stdout()

def parse_args(args=None, namespace=None):
    parser = argparse.ArgumentParser(description='Origin Dataset To Json')
    parser.add_argument('--dataset_name', type=str, default="AndroidControl",
                        help='dataset name')
    parser.add_argument('--dataset_type', type=str, default='low', help='dataset type')
    parser.add_argument('--dataset_path', type=str, default="/data3/cpz/datasets/android_control_parsed",
                        help='dataset path')
    parser.add_argument('--model_name', type=str, default="GUI_OWL",
                        help='model name')
    parser.add_argument('--save_path', type=str, default="/Agent_ScanKit/datasets/json",
                        help='save path')
    return parser.parse_args()


      
class AndroidControlPreProcess(BasePreProcess):
    def __init__(self, dataset_type, dataset_path, dataset_name, save_path, model_name):
        super().__init__(dataset_path, dataset_name, save_path, model_name)
        self.dataset_type = dataset_type
        self.split_json_name = "android_control_splits.json"
        self.split_json_data = self._merge_train_validation()
    
    def OS_ATLAS(self):
        sample = super().OS_ATLAS()
        def actionMapping(action, image_size):
            """
            ['click', 'open_app', 'long_press', 'navigate_home', 'scroll', 'navigate_back', 'wait', 'input_text']
            """
            if action['action_type'] == 'click':
                return f"CLICK <point>[[{action['x']/image_size[0]*1000}, {action['y']/image_size[1]*1000}]]</point>" 
            elif action['action_type'] == "wait":
                return "WAIT"
            elif action['action_type'] == "long_press":
                return f"LONG_CLICK <point>[[{action['x']}, {action['y']}]]</point>"
            elif action['action_type'] == "open_app":
                return f"OPENAPP [{action['app_name']}]"
            elif action['action_type'] == "navigate_home":
                return "PRESS_HOME"
            elif action['action_type'] == "navigate_back":
                return "PRESS_BACK"
            elif action["action_type"] == "scroll":
                return f"SCROLL [{action['direction'].upper()}]"
            elif action["action_type"] == "input_text":
                return f"TYPE [{action['text']}]"
            elif action['action_type'] == "complete":
                return "COMPLETE"
            else:
                logger.error(f"Action mapping error: {action}")
        for key in self.split_json_data.keys():
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            for item in tqdm(self.split_json_data[key]):
                  logger.info(f"Processing the episode: {item}")
                  episod_path = os.path.join(self.path, "episode_"+str(item))
                  metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                  metadata['actions'] += [{"action_type":"complete"}]
                  metadata['image_size'] = [[width, height] for width, height in zip(metadata['screenshot_widths'], metadata['screenshot_heights'])]
                  action_traslate = [actionMapping(action, image_size) for (action, image_size) in zip(metadata['actions'], metadata['image_size'])]
                  metadata['step_instructions'] += ["task is finished"]
        
                  for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      record["images"] = [metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['messages'][1]['content'] = action_traslate[i]
                      record['label'] = "action:\n"+action_traslate[i]
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      if self.dataset_type == 'low':
                          record['messages'][0]['content'] = ANDROIDCONTROLLOWACTIONPREDICTPROMPT_FOROSATLAS.replace("{finalGoal}", metadata['goal'])
                          record['messages'][0]['content'] = record['messages'][0]['content'].replace("{actionDesc}", metadata['step_instructions'][i])
                      else:
                          record['messages'][0]['content'] = ANDROIDCONTROLHIGHACTIONPREDICTPROMPT_FOROSATLAS.replace("{finalGoal}", metadata['goal'])
                      record['messages'][0]['content'] = record['messages'][0]['content'].replace("{previousActions}", str(metadata['step_instructions'][:i]))
                      data.append(record)
             
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")

    def UI_TARS(self):
        sample = super().UI_TARS()
        def actionMapping(action, image_size):
            """
            ['click', 'open_app', 'long_press', 'navigate_home', 'scroll', 'navigate_back', 'wait', 'input_text']
            """
            if action['action_type'] == 'click':
                if "1.5" in self.model_name:
                    return f"click(start_box='({action['x']},{action['y']})')" 
                return f"click(start_box='({int(action['x']/image_size[0]*1000)},{int(action['y']/image_size[1]*1000)})')" 
            elif action['action_type'] == "wait":
                return "wait()"
            elif action['action_type'] == "long_press":
                if "1.5" in self.model_name:
                    return f"long_press(start_box='({action['x']},{action['y']})', time='')"
                return f"long_press(start_box='({int(action['x']/image_size[0]*1000)},{int(action['y']/image_size[1]*1000)})', time='')"
            elif action['action_type'] == "open_app":
                return f"open_app(app_name='{action['app_name']}')"
            elif action['action_type'] == "navigate_home":
                return "press_home()"
            elif action['action_type'] == "navigate_back":
                return "press_back()"
            elif action["action_type"] == "scroll":
                return f"scroll(direction='{action['direction']}')"
            elif action["action_type"] == "input_text":
                return f"type(content='{action['text']}')"
            elif action['action_type'] == "complete":
                return "finished()"
            else:
                logger.error(f"Action mapping error: {action}")

        def build_history(index, metadata, image_size_list):
            history = []
          
            image_indices = range(0, index) if index <= 4 else range(index - 4, index)

            for i in range(len(metadata['screenshots'])):
                if i in image_indices:
                    image_history = {
                        "role": "user",
                        "content": [
                            {
                                "type": "image",
                                "image": metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                            }
                        ]
                    }
                    history.append(image_history)
                if i in image_indices:
                    action = actionMapping(metadata['actions'][i], image_size_list[i])
                    thought = metadata['step_instructions'][i]
                    text_history = {
                        "role": "assistant",
                        "content": [
                            {"type": "text", "text": f"Thought: {thought}\nAction: {action}"}
                        ]
                    }
                    history.append(text_history)
            return history
      
        for key in self.split_json_data.keys():
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            for item in tqdm(self.split_json_data[key]):
                  logger.info(f"Processing the episode: {item}")
                  episod_path = os.path.join(self.path, "episode_"+str(item))
                  metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                  metadata['actions'] += [{"action_type":"complete"}]
                  metadata['image_size'] = [[width, height] for width, height in zip(metadata['screenshot_widths'], metadata['screenshot_heights'])]
                  action_traslate = [actionMapping(action, image_size) for (action, image_size) in zip(metadata['actions'], metadata['image_size'])]
                  metadata['step_instructions'] += ["task is finished"]
          
                  for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      if self.dataset_type == 'low':
                          record['messages'][1]['content'][0]['text'] = ANDROIDCONTROLLOWACTIONPREDICTPROMPT_FORUITARAS.replace("{instruction}", metadata['goal'])
                          if i != 0:
                              record['messages'].extend(build_history(i, metadata, metadata['image_size'])) 
                          record['messages'].extend([
                              {
                                  "role": "user",
                                  "content": [
                                      {
                                          "type": "image",
                                          "image": metadata['screenshots'][i].replace(
                                              "android_control_parsed_data_fixed/",
                                              "/data3/cpz/datasets/android_control_parsed/"
                                          )
                                      }
                                  ]
                              },
                              {
                                  "role": "assistant",
                                  "content": [
                                      {
                                          "type": "text",
                                          "text": f"Thought: {metadata['step_instructions'][i]}\n"
                                      }
                                  ]
                              }
                          ])
                      else:
                          record['messages'][1]['content'][0]['text'] = ANDROIDCONTROLHIGHACTIONPREDICTPROMPT_FORUITARAS.replace("{instruction}", metadata['goal'])
                          if i != 0:
                              record['messages'].extend(build_history(i, metadata, metadata['image_size'])) 
                          record['messages'].extend([
                              {
                                  "role": "user",
                                  "content": [
                                      {
                                          "type": "image",
                                          "image": metadata['screenshots'][i].replace(
                                              "android_control_parsed_data_fixed/",
                                              "/data3/cpz/datasets/android_control_parsed/"
                                          )
                                      }
                                  ]
                              }
                          ])

                          
                      record['label'] = f"Thought: {metadata['step_instructions'][i]}\nAction: {action_traslate[i]}"
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      record["images"] = [metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      
                      data.append(record)
             
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")
        
    def GUI_R1(self):
        sample = super().GUI_R1()
        def actionMapping(action):
            """
            ['click', 'open_app', 'long_press', 'navigate_home', 'scroll', 'navigate_back', 'wait', 'input_text']
            """
            t = action['action_type']
            if t == 'navigate_home':
                action_name = 'press_home'
            elif t == 'navigate_back':
                action_name = 'press_back'
            elif t == 'complete':
                action_name = 'complete'
            else:
                action_name = t

            if t in ['click', 'long_press']:
                point = [action.get('x', -100), action.get('y', -100)]
            else:
                point = [-100, -100]

            if t in ['click', 'long_press', 'wait', 'complete', 'navigate_home', 'navigate_back']:
                input_text = 'no input text'
            elif t == 'open_app':
                input_text = action.get('app_name', '')
            elif t == 'scroll':
                map_direction = {'left': 'right', 'right': 'left', 'up': 'down', 'down': 'up'}
                input_text = map_direction[action['direction']]
            elif t == 'input_text':
                action_name = 'type'
                input_text = action.get('text', '')
            else:
                input_text = 'no input text'
            
            formatted_action = [{
                'action': action_name,
                'point': point,
                'input_text': input_text
            }]
            return str(formatted_action)
        for key in self.split_json_data.keys():
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            for item in tqdm(self.split_json_data[key]):
                logger.info(f"Processing the episode: {item}")
                episod_path = os.path.join(self.path, "episode_"+str(item))
                metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                metadata['actions'] += [{"action_type":"complete"}]
                action_traslate = [actionMapping(action) for action in metadata['actions']]
                metadata['step_instructions'] += ["task is finished"]
            
                for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      record["images"] = [metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['messages'][0]['content'][0]['image'] = record['images'][0]          
                      record['label'] = "<think></think><answer>"+action_traslate[i]+"</answer>"
                      if self.dataset_type == 'low':
                          record['messages'][0]['content'][1]['text'] = '<image>\n' + ANDROIDCONTROLLOWACTIONPREDICTPROMPT_FORGUIR1.replace("{goal}", metadata['step_instructions'][i])
                      else:
                          record['messages'][0]['content'][1]['text'] = '<image>\n' + ANDROIDCONTROLHIGHACTIONPREDICTPROMPT_FORGUIR1.replace("{goal}", metadata['goal'])
                      record['messages'][0]['content'][1]['text'] = record['messages'][0]['content'][1]['text'].replace("{history}", str(metadata['step_instructions'][:i]))
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      data.append(record)
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")

    def Agent_CPM(self):
        sample = super().Agent_CPM()
        def actionMapping(action, image_size):
            """
            ['click', 'open_app', 'long_press', 'navigate_home', 'scroll', 'navigate_back', 'wait', 'input_text']
            """
            t = action['action_type']
   
            if t == 'click':
                return str({"thought":"", "POINT": [action['x']/image_size[0]*1000, action['y']/image_size[1]*1000]})
            elif t == 'long_press':
                return str({"thought":"", "POINT": [action['x']/image_size[0]*1000, action['y']/image_size[1]*1000], "duration": 1000})
            elif t == 'navigate_home':
                return str({"thought":"", "PRESS": "HOME"})
            elif t == 'navigate_back':
                return str({"thought":"", "PRESS": "BACK"})
            elif t == 'scroll':
                map_direction = {'left': 'right', 'right': 'left', 'up': 'down', 'down': 'up'}
                direction = map_direction[action['direction']]
                return str({"thought":"", "POINT": [-100, -100], "to": direction})
            elif t == 'input_text':
                return str({"thought":"", "TYPE": action['text']})
            elif t == "wait":
                return str({"thought":"", 'duration': -100})
            elif t == "complete":
                return str({"thought":"", 'STATUS': 'finish'})
            else:
                return "error" 
        from prompt.androidControlPrompt import AGENT_CPM_SYSTEM_PROMPT
        ACTION_SCHEMA = json.load(open('/Agent_ScanKit/utils/schema/agentCPMSchema.json', encoding="utf-8"))
        items = list(ACTION_SCHEMA.items())
        insert_index = 3
        items.insert(insert_index, ("required", ["thought"])) 
        ACTION_SCHEMA = dict(items)
        AGENT_CPM_SYSTEM_PROMPT = AGENT_CPM_SYSTEM_PROMPT.replace("ACTION_SCHEMA", str(ACTION_SCHEMA))
                
        for key in self.split_json_data.keys():
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            for item in tqdm(self.split_json_data[key]):
                logger.info(f"Processing the episode: {item}")
                episod_path = os.path.join(self.path, "episode_"+str(item))
                metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                metadata['actions'] += [{"action_type":"complete"}]
                metadata['image_size'] = [[width, height] for width, height in zip(metadata['screenshot_widths'], metadata['screenshot_heights'])]
                action_traslate = [actionMapping(action, image_size) for (action, image_size) in zip(metadata['actions'], metadata['image_size'])]
                metadata['step_instructions'] += ["task is finished"]
                for i in range(len(action_traslate)):
                      if action_traslate[i] == 'error':
                          continue
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      record["images"] = [metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']                  
                      record['label'] = action_traslate[i]
                      if self.dataset_type == 'low':
                          record['messages'][0]['content'][0] = record['messages'][0]['content'][0].replace("text_prompt", metadata['step_instructions'][i])
                      else:
                          record['messages'][0]['content'][0] = record['messages'][0]['content'][0].replace("text_prompt", metadata['goal'])
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      record['system_prompt'] = AGENT_CPM_SYSTEM_PROMPT
                      data.append(record)
               
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")


    def OS_Genesis(self):
        sample = super().OS_Genesis()
        def actionMapping(action, thought, dataset_type):
            t = action['action_type']
            if t == 'click':
                return f'Low-level thought: {thought} action: {{"action_type": "click", "x": {action["x"]}, "y": {action["y"]}}}'
            elif t == 'long_press':
                return f'Low-level thought: {thought} action: {{"action_type": "long_press", "x": {action["x"]}, "y": {action["y"]}}}'
            elif t == 'navigate_home':
                return f'Low-level thought: {thought} action: {{"action_type": "navigate_home"}}'
            elif t == 'navigate_back':
                return f'Low-level thought: {thought} action: {{"action_type": "navigate_back"}}'
            elif t == 'scroll':
                direction = action['direction']
                if dataset_type =='low':
                    map_direction = {"left": "right", "right": "left", "up": "down", "down": "up"}
                    direction = map_direction[action['direction']]
                return f'Low-level thought: {thought} action: {{"action_type": "scroll", "direction": "{direction}"}}'
            elif t == 'input_text':
                action_dict = {
                    "action_type": "type",
                    "text": action["text"],
                    "x": -100,
                    "y": -100
                }
                json_action = json.dumps(action_dict)
                return f"Low-level thought: {thought} action: {json_action}"
            elif t == "wait":
                return f"Low-level thought: {thought} action: {{'action_type': 'wait'}}"
            elif t == "open_app":
                return f'Low-level thought: {thought} action: {{"action_type": "open_app", "app_name": "{action["app_name"]}"}}'
            elif t == 'complete':
                return f"Low-level thought: {thought} action: {{'action_type': 'stop'}}"
            else:
                return "error" 
        
        def get_a11_tree(a11_tree_path):
            clickable_nodes = {}
            with open(a11_tree_path, 'r', encoding='utf-8') as f:
                for line in f:
                    try:
                        node = json.loads(line)
                        text = node.get("text") or node.get("content_description")
                        if not text:
                            continue
                        bbox = node.get("bbox_pixels")
                        if not bbox:
                            continue
                        center_x = (bbox["x_min"] + bbox["x_max"]) / 2
                        center_y = (bbox["y_min"] + bbox["y_max"]) / 2
                        clickable_nodes[text.strip()] = (center_x, center_y)
                    except (json.JSONDecodeError, KeyError, TypeError):
                        continue
            return clickable_nodes
        from prompt.androidControlPrompt import OS_GENESIS_HIGH_PROMPT, OS_GENESIS_LOW_PROMPT
        
        for key in self.split_json_data.keys():
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            for item in tqdm(self.split_json_data[key]):
                  logger.info(f"Processing the episode: {item}")
                  episod_path = os.path.join(self.path, "episode_"+str(item))
                  metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                  metadata['actions'] += [{"action_type":"stop"}]
                  metadata['step_instructions'] += ["task is finished"]
                  action_traslate = [actionMapping(action, low_level_instruction, self.dataset_type) for (action, low_level_instruction) in zip(metadata['actions'], metadata['step_instructions'])]
                  
                  for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      record["images"] = [metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['label'] = action_traslate[i]
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      previous_actions = [f"Step {step}:{low_level}" for step, low_level in enumerate(metadata['step_instructions'][:i])]
                      if self.dataset_type == 'low':
                          record['question'] = OS_GENESIS_LOW_PROMPT.format(instruction=record['goal'], history='\n'.join(previous_actions), a11y_tree=str(get_a11_tree(record['accessibility_trees'])),low_level_thought=metadata['step_instructions'][i])
                      else:
                          record['question'] = OS_GENESIS_HIGH_PROMPT.format(instruction=record['goal'], history=previous_actions, a11y_tree=str(get_a11_tree(record['accessibility_trees'])))           
                      data.append(record)
             
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")

    def Aguvis(self):
        sample = super().Aguvis()
        from utils.schema.aguvisConstants import user_instruction
        def actionMapping(action, image_size):
            """
            ['click', 'open_app', 'long_press', 'navigate_home', 'scroll', 'navigate_back', 'wait', 'input_text']
            """
            t = action['action_type']
   
            if t == 'click':
                return f"assistantos\npyautogui.click(x={action['x']/image_size[0]}, y={action['y']/image_size[1]})"
            elif t == 'long_press':
                return f"assistantos\nmobile.long_press(x={action['x']/image_size[0]}, y={action['y']/image_size[1]})"
            elif t == 'navigate_home':
                return f"assistantos\nmobile.home()"
            elif t == 'navigate_back':
                return f"assistantos\nmobile.back()"
            elif t == 'scroll':
                direction = action['direction']
                if direction in ['left', 'right']:
                    if direction == 'left':
                        return "assistantos\npyautogui.hscroll(page=-0.1)"
                    else:
                        return "assistantos\npyautogui.hscroll(page=0.1)"
                else:
                    if direction == 'up':
                        return "assistantos\npyautogui.scroll(page=0.1)"
                    else:
                        return "assistantos\npyautogui.scroll(page=-0.1)"
            elif t == 'input_text':
                return f"assistantos\npyautogui.write(message='{action['text']}')"
            elif t == "wait":
                return f"assistantos\nmobile.wait(seconds=3)"
            elif t == "complete":
                return "assistantos\nmobile.terminate(status='success')"
            elif t == "open_app":
                return f"assistantos\nmobile.open_app(app_name='{action['app_name']}')"
            else:
                return "error" 
        
        for key in self.split_json_data.keys():
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            for item in tqdm(self.split_json_data[key]):
                  logger.info(f"Processing the episode: {item}")
                  episod_path = os.path.join(self.path, "episode_"+str(item))
                  metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                  metadata['actions'] += [{"action_type":"complete"}]
                  metadata['image_size'] = [[width, height] for width, height in zip(metadata['screenshot_widths'], metadata['screenshot_heights'])]
                  action_traslate = [actionMapping(action, image_size) for (action, image_size) in zip(metadata['actions'], metadata['image_size'])]
                  metadata['step_instructions'] += ["task is finished"]

                  for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      record["images"] = [metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['label'] = action_traslate[i]
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      previous_actions = [f"Step{step}:{low_level}" for step, low_level in enumerate(metadata['step_instructions'][:i])]
                      if self.dataset_type == 'low':
                          record['messages']['content'][1]['text'] = user_instruction.format(overall_goal=record['goal'], previous_actions=previous_actions, low_level_instruction=metadata['step_instructions'][i])
                          record['is_low_level_instruction'] = True
                          record['low_level_instruction'] = metadata['step_instructions'][i]
                      else:
                          record['messages']['content'][1]['text'] = user_instruction.format(overall_goal=record['goal'], previous_actions=previous_actions, low_level_instruction="")
                          record['is_low_level_instruction'] = False 
                      record['mode'] = 'force-plan'                  
                      data.append(record)
             
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            print(len(data))
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")
      
    def GUI_Odyssey(self):
        sample = super().GUI_Odyssey()
        def actionMapping(action, image_size):
            if action['action_type'] == 'click':
                return f"CLICK: ({int(action['x']/image_size[0]*1000)}, {int(action['y']/image_size[1]*1000)})"
            elif action['action_type'] == "wait":
                return "WAIT"
            elif action['action_type'] == "long_press":
                return f"LONG_PRESS: ({int(action['x']/image_size[0]*1000)}, {int(action['y']/image_size[1]*1000)})"
            elif action['action_type'] == "open_app":
                return f"OPENAPP: {action['app_name']}"
            elif action['action_type'] == "navigate_home":
                return "PRESS_HOME"
            elif action['action_type'] == "navigate_back":
                return "PRESS_BACK"
            elif action["action_type"] == "scroll":
                return f"SCROLL: {action['direction'].upper()}"
            elif action["action_type"] == "input_text":
                return f"TYPE: {action['text']}"
            elif action['action_type'] == "complete":
                return "COMPLETE"
            else:
                logger.error(f"Action mapping error: {action}")
        
        for key in self.split_json_data.keys():
            if key == 'train':
                continue
            data = []
            hit_index = {}
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            count = 0
            for item in self.split_json_data[key]:
                  logger.info(f"Processing the episode: {item}")
                  episod_path = os.path.join(self.path, "episode_"+str(item))
                  metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                  metadata['actions'] += [{"action_type":"complete"}]
                  metadata['image_size'] = [[metadata['screenshot_widths'][i], metadata['screenshot_heights'][i]] for i in range(len(metadata['screenshots']))]
                  action_traslate = [actionMapping(action, image_size) for action, image_size in zip(metadata['actions'], metadata['image_size'])]
                  metadata['step_instructions'] += ["task is finished"]
                  previous_action_history: list = []
                  previous_screenshot_history: list = []
                  count += len(action_traslate)
                  for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      img = metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record["images"] = [img]
                      hit_index[f"{img}"] = previous_screenshot_history[:i]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['label'] = action_traslate[i]
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      if self.dataset_type == 'low':
                          question = record['question'].format(
                              instruction=metadata['step_instructions'][i], 
                              image_path=record['images'][0]
                          )
                      else:
                          question = record['question'].format(
                              instruction=record['goal'], 
                              image_path=record['images'][0]
                          )

                      if i > 0:
                            his_img = f'\nPrevious screenshots: <img>image-history: {img}</img>'
                            his_str = '\nPrevious Actions: '
                            for idx, hi in enumerate(previous_action_history[-4:]):
                                his_str += f"{idx+1}. {hi}\n"
                            question = f"{question}{his_img}{his_str}"
                      else:
                            question += f'\nPrevious screenshots: None'
                            question += f'\nPrevious Actions: None'
                      question += '\nProvide the command-style action directly.'
                      record['question'] = question
                      record['low_level_instruction'] = metadata['step_instructions'][i]
                      previous_action_history.append(action_traslate[i])
                      previous_screenshot_history.append(img)
                      data.append(record)
             
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            self.saveJson(hit_index, os.path.join("/data1/Agent_ScanKit/utils/utils_odyssey", f"his_index.json"))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")

    def GUI_OWL(self):
        build_system_messages, getResizedImage, build_user_messages, sample = super().GUI_OWL()
        def actionMapping(action):
            if action['action_type'] == 'click':
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "click", "coordinate": [{action["x"]}, {action["y"]}]}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action['action_type'] == "wait":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "wait", "time": {2}}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action['action_type'] == "long_press":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "long_press", "coordinate": [{action["x"]}, {action["y"]}], "time": {2}}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action['action_type'] == "open_app":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "open", "text": "{action['app_name']}"}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action['action_type'] == "navigate_home":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "system_button", "button": "Home"}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action['action_type'] == "navigate_back":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "system_button", "button": "Back"}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action["action_type"] == "scroll":
                direction = action['direction'].upper()
                if direction == 'UP':
                    x1, y1 = 0, 0
                    x2, y2 = 0, 1
                elif direction == 'DOWN':
                    x1, y1 = 0, 1
                    x2, y2 = 0, 0
                elif direction == 'LEFT':
                    x1, y1 = 0, 0
                    x2, y2 = 1, 0
                else:
                    x1, y1 = 1, 0
                    x2, y2 = 0, 1
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "swipe", "coordinate": [{x1}, {y1}], "coordinate2": [{x2}, {y2}]}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action["action_type"] == "input_text":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "type", "text": "{action['text']}"}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            elif action['action_type'] == "complete":
                return f"""<thinking>\n""\n</thinking>\n<tool_call>\n{{"name": "mobile_use", "arguments": {{"action": "terminate", "status": "success"}}}}\n</tool_call>\n<conclusion>\n""\n</conclusion>"""
            else:
                logger.error(f"Action mapping error: {action}")
        
        for key in self.split_json_data.keys():
            if key == 'train':
                continue
            data = []
            logger.info(f"Processing the {key} samples in the {self.dataset_name}")
            count = 0
            for item in self.split_json_data[key]:
                  logger.info(f"Processing the episode: {item}")
                  episod_path = os.path.join(self.path, "episode_"+str(item))
                  metadata = self.readJson(os.path.join(episod_path, "metadata_episode_"+str(item)+".json"))
                  metadata['actions'] += [{"action_type":"complete"}]
                  metadata['image_size'] = [[metadata['screenshot_widths'][i], metadata['screenshot_heights'][i]] for i in range(len(metadata['screenshots']))]
                  action_traslate = [actionMapping(action) for action in metadata['actions']]
                  metadata['step_instructions'] += ["task is finished"]

                  for i in range(len(action_traslate)):
                      from copy import deepcopy
                      record = deepcopy(sample)
                      record["episode_id"] = metadata["episode_id"]
                      record["step_id"] = i+1
                      img = metadata['screenshots'][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record["images"] = [img]
                      record['accessibility_trees'] = metadata["accessibility_trees"][i].replace("android_control_parsed_data_fixed/", "/data3/cpz/datasets/android_control_parsed/")
                      record['goal'] = metadata['goal']          
                      record['label'] = action_traslate[i]
                      record['image_size'] = [(metadata['screenshot_widths'][i], metadata['screenshot_heights'][i])]
                      dummy_image = getResizedImage(record['images'][0])
                      system_messages = build_system_messages(dummy_image.height, dummy_image.width)
                      
                      if self.dataset_type == 'low':
                          user_messages = build_user_messages(metadata['step_instructions'][i], enable_think=True, history=metadata['step_instructions'][:i])
                      else:
                          user_messages = build_user_messages(record['goal'], enable_think=True, history=metadata['step_instructions'][:i])

                      user_messages['content'].append({"image": record['images'][0]})
                      messages = [system_messages, user_messages]
                      record['messages'] = message_translate(messages, to_format='qwen')
                      data.append(record)
             
            if not os.path.exists(self.save_path):
                os.makedirs(self.save_path)
            self.saveJson(data, os.path.join(self.save_path, self.dataset_type+"_"+str(key)+"_"+self.model_name.lower()+'.json'))
            logger.info(f"transform {self.dataset_type} of {self.dataset_name} dataset to json succesfuully")
        logger.info("Finished")

    

    def _merge_train_validation(self):
        split_json_path = os.path.join(self.path, self.split_json_name)
        split_json_data = self.readJson(split_json_path)
        split_json_data['train'] += split_json_data['validation']
        del split_json_data['validation']
        return split_json_data
            
    
if __name__ == '__main__':
    args = parse_args()
    logger.info(args)
    if args.dataset_name == 'AndroidControl':
        process = AndroidControlPreProcess(
            args.dataset_type, args.dataset_path, args.dataset_name, args.save_path, args.model_name)
        if args.model_name == "OS_ATLAS":
            process.OS_ATLAS()
        elif args.model_name == "UI_TARS" or args.model_name == "UI_TARS_1.5":
            process.UI_TARS()
        elif args.model_name == 'GUI_R1':
            process.GUI_R1()
        elif args.model_name == 'Agent_CPM':
            process.Agent_CPM()
        elif args.model_name == 'OS_Genesis':
            process.OS_Genesis()
        elif args.model_name == 'Aguvis':
            process.Aguvis()
        elif args.model_name == 'GUI_Odyssey':
            process.GUI_Odyssey()
        elif args.model_name == 'GUI_OWL':
            process.GUI_OWL()
        else:
            logger.info("error processing")
   